;
;								EJEMPLO 5
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Mquina de taladrado
;
;Al accionar el pulsador "I" (RA0) el cabezal realiza un descenso rpido de aproximacin,
;activando el motor de bajada rpida "BR"(RB3). Al llegar al sensor "b" (RA2), se activa 
;el rel "M" (RB1) que hace girar el motor de la broca y se realiza un descenso lento para 
;el taladrado de la pieza "BL" (RB4). Cuando se activa el sensor "c" (RA3) se considera 
;que la pieza est taladrada. Se inicia una subida rpida del cabezal "SR" (RB0) al tiempo
;que el rel "M" (RB1) de giro sigue activado. Cuando se alcanza el final de carrera "a" 
;(RA1), se detiene la subida rpida "SR"(RB0), el rel de giro "M" (RB1) y se activa una 
;seal acstica "A" (RA2) de aviso. El ciclo comienza con una nueva pulsacin de "I" (RA0).
	
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

;Estos y otros valores se pueden modificar segn las necesidades

			org		0x00
			goto	Inicio		;Vector de reset
			org		0x05	
	
Inicio	    clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00011111'		
			movwf	TRISA		;Puerta A se configura como entrada
			bcf		STATUS,RP0	;Selecciona banco 0			

Loop:		btfsc	PORTA,0		;Chequea si est activado "I"
			goto	Loop		;No, secuencia detenida.
			bcf		PORTB,2		;Si, inicia secuencia, acstico en OFF
			bsf		PORTB,3		;Activa bajada rpida "BR".

Espera_b	btfsc	PORTA,2		;Chequea el sensor "b"
			goto	Espera_b	;Desactivado, espera.
			bcf		PORTB,3		;"b" activado, bajada rpida en OFF
			bsf		PORTB,4		;Bajada lenta "BL" en ON
			bsf		PORTB,1		;Motor "M" en ON

Espera_c	btfsc	PORTA,3		;Chequea el sensor "c"
			goto	Espera_c	;Desactivado, espera.
			bcf		PORTB,4		;"c" activado, bajada lenta en OFF
			bsf		PORTB,0		;Subida rpida "SR" en ON
					
Espera_a	btfsc	PORTA,1		;Chequea el sensor "a"
			goto	Espera_a	;Desactivado, espera
			bsf		PORTB,2		;"a" activado, acstico en ON
			bcf		PORTB,0		;Subida rpida en OFF
			bcf		PORTB,1		;Motor en OFF
			goto	Loop

			end			;Fin del programa fuente
